/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.model;

import java.io.IOException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;

public class XWPFHeaderFooterPolicy {
    private XWPFHeader firstPageHeader;
    private XWPFFooter firstPageFooter;
    private XWPFHeader evenPageHeader;
    private XWPFFooter evenPageFooter;
    private XWPFHeader defaultHeader;
    private XWPFFooter defaultFooter;

    public XWPFHeaderFooterPolicy(XWPFDocument doc) throws IOException, XmlException {
        CTHdrFtrRef ref;
        int i;
        CTSectPr sectPr = doc.getDocument().getBody().getSectPr();
        for (i = 0; i < sectPr.sizeOfHeaderReferenceArray(); ++i) {
            ref = sectPr.getHeaderReferenceArray(i);
            PackagePart hdrPart = doc.getPartById(ref.getId());
            XWPFHeader hdr = new XWPFHeader(HdrDocument.Factory.parse(hdrPart.getInputStream()).getHdr());
            if (ref.getType() == STHdrFtr.FIRST) {
                this.firstPageHeader = hdr;
                continue;
            }
            if (ref.getType() == STHdrFtr.EVEN) {
                this.evenPageHeader = hdr;
                continue;
            }
            this.defaultHeader = hdr;
        }
        for (i = 0; i < sectPr.sizeOfFooterReferenceArray(); ++i) {
            ref = sectPr.getFooterReferenceArray(i);
            PackagePart ftrPart = doc.getPartById(ref.getId());
            XWPFFooter ftr = new XWPFFooter(FtrDocument.Factory.parse(ftrPart.getInputStream()).getFtr());
            if (ref.getType() == STHdrFtr.FIRST) {
                this.firstPageFooter = ftr;
                continue;
            }
            if (ref.getType() == STHdrFtr.EVEN) {
                this.evenPageFooter = ftr;
                continue;
            }
            this.defaultFooter = ftr;
        }
    }

    public XWPFHeader getFirstPageHeader() {
        return this.firstPageHeader;
    }

    public XWPFFooter getFirstPageFooter() {
        return this.firstPageFooter;
    }

    public XWPFHeader getOddPageHeader() {
        return this.defaultHeader;
    }

    public XWPFFooter getOddPageFooter() {
        return this.defaultFooter;
    }

    public XWPFHeader getEvenPageHeader() {
        return this.evenPageHeader;
    }

    public XWPFFooter getEvenPageFooter() {
        return this.evenPageFooter;
    }

    public XWPFHeader getDefaultHeader() {
        return this.defaultHeader;
    }

    public XWPFFooter getDefaultFooter() {
        return this.defaultFooter;
    }

    public XWPFHeader getHeader(int pageNumber) {
        if (pageNumber == 1 && this.firstPageHeader != null) {
            return this.firstPageHeader;
        }
        if (pageNumber % 2 == 0 && this.evenPageHeader != null) {
            return this.evenPageHeader;
        }
        return this.defaultHeader;
    }

    public XWPFFooter getFooter(int pageNumber) {
        if (pageNumber == 1 && this.firstPageFooter != null) {
            return this.firstPageFooter;
        }
        if (pageNumber % 2 == 0 && this.evenPageFooter != null) {
            return this.evenPageFooter;
        }
        return this.defaultFooter;
    }
}

