/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.extractor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.POITextExtractor;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.model.XWPFHyperlinkDecorator;
import org.apache.poi.xwpf.model.XWPFParagraphDecorator;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlException;

public class XWPFWordExtractor
extends POIXMLTextExtractor {
    private XWPFDocument document;
    private boolean fetchHyperlinks = false;

    public XWPFWordExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        this(new XWPFDocument(container));
    }

    public XWPFWordExtractor(XWPFDocument document) {
        super(document);
        this.document = document;
    }

    public void setFetchHyperlinks(boolean fetch) {
        this.fetchHyperlinks = fetch;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  HXFWordExtractor <filename.docx>");
            System.exit(1);
        }
        XWPFWordExtractor extractor = new XWPFWordExtractor(POIXMLDocument.openPackage(args[0]));
        System.out.println(((POITextExtractor)extractor).getText());
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        XWPFHeaderFooterPolicy hfPolicy = this.document.getHeaderFooterPolicy();
        if (hfPolicy.getFirstPageHeader() != null) {
            text.append(hfPolicy.getFirstPageHeader().getText());
        }
        if (hfPolicy.getEvenPageHeader() != null) {
            text.append(hfPolicy.getEvenPageHeader().getText());
        }
        if (hfPolicy.getDefaultHeader() != null) {
            text.append(hfPolicy.getDefaultHeader().getText());
        }
        Iterator<XWPFParagraph> i = this.document.getParagraphsIterator();
        while (i.hasNext()) {
            XWPFCommentsDecorator decorator = new XWPFCommentsDecorator(new XWPFHyperlinkDecorator(i.next(), null, this.fetchHyperlinks));
            text.append(((XWPFParagraphDecorator)decorator).getText() + "\n");
        }
        Iterator<XWPFTable> j = this.document.getTablesIterator();
        while (j.hasNext()) {
            text.append(j.next().getText() + "\n");
        }
        if (hfPolicy.getFirstPageFooter() != null) {
            text.append(hfPolicy.getFirstPageFooter().getText());
        }
        if (hfPolicy.getEvenPageFooter() != null) {
            text.append(hfPolicy.getEvenPageFooter().getText());
        }
        if (hfPolicy.getDefaultFooter() != null) {
            text.append(hfPolicy.getDefaultFooter().getText());
        }
        return text.toString();
    }
}

