/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.helpers.RichTextStringHelper;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;

public class XSSFComment
implements Comment {
    private CTComment comment;
    private CommentsTable comments;

    public XSSFComment(CommentsTable comments, CTComment comment) {
        this.comment = comment;
        this.comments = comments;
    }

    public String getAuthor() {
        return this.comments.getAuthor((int)this.comment.getAuthorId());
    }

    public int getColumn() {
        return new CellReference(this.comment.getRef()).getCol();
    }

    public int getRow() {
        return new CellReference(this.comment.getRef()).getRow();
    }

    public boolean isVisible() {
        return true;
    }

    public void setAuthor(String author) {
        this.comment.setAuthorId(this.comments.findAuthor(author));
    }

    public void setColumn(short col) {
        this.initializeRef();
        String newRef = new CellReference(this.getRow(), col).formatAsString();
        this.comment.setRef(newRef);
    }

    private void initializeRef() {
        if (this.comment.getRef() == null) {
            this.comment.setRef("A1");
        }
    }

    public void setRow(int row) {
        this.initializeRef();
        String newRef = new CellReference(row, this.getColumn()).formatAsString();
        this.comment.setRef(newRef);
    }

    public RichTextString getString() {
        return RichTextStringHelper.convertFromRst(this.comment.getText());
    }

    public void setString(RichTextString string) {
        CTRst text = this.comment.addNewText();
        RichTextStringHelper.convertToRst(string, text);
    }

    public void setString(String string) {
        XSSFRichTextString richTextString = new XSSFRichTextString(string);
        this.setString(richTextString);
    }

    public void setVisible(boolean visible) {
    }
}

