/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public class XSSFCellStyle
implements CellStyle {
    private int cellXfId;
    private StylesTable stylesSource;
    private CTXf cellXf;
    private CTXf cellStyleXf;
    private XSSFFont font;
    private XSSFCellAlignment cellAlignment;

    public XSSFCellStyle(int cellXfId, int cellStyleXfId, StylesTable stylesSource) {
        this.cellXfId = cellXfId;
        this.stylesSource = stylesSource;
        this.cellXf = stylesSource.getCellXfAt(this.cellXfId);
        this.cellStyleXf = stylesSource.getCellStyleXfAt(cellStyleXfId);
    }

    public CTXf getCoreXf() {
        return this.cellXf;
    }

    public CTXf getStyleXf() {
        return this.cellStyleXf;
    }

    public XSSFCellStyle(StylesTable stylesSource) {
        this.stylesSource = stylesSource;
        this.cellXf = CTXf.Factory.newInstance();
        this.cellStyleXf = null;
    }

    public void verifyBelongsToStylesSource(StylesTable src) {
        if (this.stylesSource != src) {
            throw new IllegalArgumentException("This Style does not belong to the supplied Workbook Stlyes Source. Are you trying to assign a style from one workbook to the cell of a differnt workbook?");
        }
    }

    public void cloneStyleFrom(CellStyle source) {
        if (!(source instanceof XSSFCellStyle)) {
            throw new IllegalArgumentException("Can only clone from one XSSFCellStyle to another, not between HSSFCellStyle and XSSFCellStyle");
        }
        XSSFCellStyle src = (XSSFCellStyle)source;
        this.cellXf.set(src.getCoreXf());
        this.cellStyleXf.set(src.getStyleXf());
    }

    public short getAlignment() {
        return (short)this.getAlignmentEnum().ordinal();
    }

    public HorizontalAlignment getAlignmentEnum() {
        CTCellAlignment align = this.cellXf.getAlignment();
        if (align != null && align.isSetHorizontal()) {
            return HorizontalAlignment.values()[align.getHorizontal().intValue() - 1];
        }
        return HorizontalAlignment.GENERAL;
    }

    public short getBorderBottom() {
        if (!this.cellXf.getApplyBorder()) {
            return 0;
        }
        int idx = (int)this.cellXf.getBorderId();
        CTBorder ct = this.stylesSource.getBorderAt(idx).getCTBorder();
        STBorderStyle.Enum ptrn = ct.isSetBottom() ? ct.getBottom().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public BorderStyle getBorderBottomEnum() {
        short style = this.getBorderBottom();
        return BorderStyle.values()[style];
    }

    public short getBorderLeft() {
        if (!this.cellXf.getApplyBorder()) {
            return 0;
        }
        int idx = (int)this.cellXf.getBorderId();
        CTBorder ct = this.stylesSource.getBorderAt(idx).getCTBorder();
        STBorderStyle.Enum ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public BorderStyle getBorderLeftEnum() {
        short style = this.getBorderLeft();
        return BorderStyle.values()[style];
    }

    public short getBorderRight() {
        if (!this.cellXf.getApplyBorder()) {
            return 0;
        }
        int idx = (int)this.cellXf.getBorderId();
        CTBorder ct = this.stylesSource.getBorderAt(idx).getCTBorder();
        STBorderStyle.Enum ptrn = ct.isSetRight() ? ct.getRight().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public BorderStyle getBorderRightEnum() {
        short style = this.getBorderRight();
        return BorderStyle.values()[style];
    }

    public short getBorderTop() {
        if (!this.cellXf.getApplyBorder()) {
            return 0;
        }
        int idx = (int)this.cellXf.getBorderId();
        CTBorder ct = this.stylesSource.getBorderAt(idx).getCTBorder();
        STBorderStyle.Enum ptrn = ct.isSetTop() ? ct.getTop().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public BorderStyle getBorderTopEnum() {
        short style = this.getBorderTop();
        return BorderStyle.values()[style];
    }

    public short getBottomBorderColor() {
        XSSFColor clr = this.getBottomBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getBottomBorderXSSFColor() {
        if (!this.cellXf.getApplyBorder()) {
            return null;
        }
        int idx = (int)this.cellXf.getBorderId();
        XSSFCellBorder border = this.stylesSource.getBorderAt(idx);
        return border.getBorderColor(XSSFCellBorder.BorderSide.BOTTOM);
    }

    public short getDataFormat() {
        return (short)this.cellXf.getNumFmtId();
    }

    public String getDataFormatString() {
        short idx = this.getDataFormat();
        return new XSSFDataFormat(this.stylesSource).getFormat(idx);
    }

    public short getFillBackgroundColor() {
        XSSFColor clr = this.getFillBackgroundXSSFColor();
        return clr == null ? IndexedColors.AUTOMATIC.getIndex() : clr.getIndexed();
    }

    public XSSFColor getFillBackgroundXSSFColor() {
        if (!this.cellXf.getApplyFill()) {
            return null;
        }
        int fillIndex = (int)this.cellXf.getFillId();
        XSSFCellFill fg = this.stylesSource.getFillAt(fillIndex);
        return fg.getFillBackgroundColor();
    }

    public short getFillForegroundColor() {
        XSSFColor clr = this.getFillForegroundXSSFColor();
        return clr == null ? IndexedColors.AUTOMATIC.getIndex() : clr.getIndexed();
    }

    public XSSFColor getFillForegroundXSSFColor() {
        if (!this.cellXf.getApplyFill()) {
            return null;
        }
        int fillIndex = (int)this.cellXf.getFillId();
        XSSFCellFill fg = this.stylesSource.getFillAt(fillIndex);
        return fg.getFillForegroundColor();
    }

    public short getFillPattern() {
        if (!this.cellXf.getApplyFill()) {
            return 0;
        }
        int fillIndex = (int)this.cellXf.getFillId();
        XSSFCellFill fill = this.stylesSource.getFillAt(fillIndex);
        STPatternType.Enum ptrn = fill.getPatternType();
        if (ptrn == null) {
            return 0;
        }
        return (short)(ptrn.intValue() - 1);
    }

    public FillPatternType getFillPatternEnum() {
        short style = this.getFillPattern();
        return FillPatternType.values()[style];
    }

    public XSSFFont getFont() {
        if (this.font == null) {
            this.font = this.stylesSource.getFontAt(this.getFontId());
        }
        return this.font;
    }

    public short getFontIndex() {
        return (short)this.getFontId();
    }

    public boolean getHidden() {
        return this.getCellProtection().getHidden();
    }

    public short getIndention() {
        CTCellAlignment align = this.cellXf.getAlignment();
        return (short)(align == null ? 0L : align.getIndent());
    }

    public short getIndex() {
        return (short)this.cellXfId;
    }

    public short getLeftBorderColor() {
        XSSFColor clr = this.getLeftBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getLeftBorderXSSFColor() {
        if (!this.cellXf.getApplyBorder()) {
            return null;
        }
        int idx = (int)this.cellXf.getBorderId();
        XSSFCellBorder border = this.stylesSource.getBorderAt(idx);
        return border.getBorderColor(XSSFCellBorder.BorderSide.LEFT);
    }

    public boolean getLocked() {
        return this.getCellProtection().getLocked();
    }

    public short getRightBorderColor() {
        XSSFColor clr = this.getRightBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getRightBorderXSSFColor() {
        if (!this.cellXf.getApplyBorder()) {
            return null;
        }
        int idx = (int)this.cellXf.getBorderId();
        XSSFCellBorder border = this.stylesSource.getBorderAt(idx);
        return border.getBorderColor(XSSFCellBorder.BorderSide.RIGHT);
    }

    public short getRotation() {
        CTCellAlignment align = this.cellXf.getAlignment();
        return (short)(align == null ? 0L : align.getTextRotation());
    }

    public short getTopBorderColor() {
        XSSFColor clr = this.getTopBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getTopBorderXSSFColor() {
        if (!this.cellXf.getApplyBorder()) {
            return null;
        }
        int idx = (int)this.cellXf.getBorderId();
        XSSFCellBorder border = this.stylesSource.getBorderAt(idx);
        return border.getBorderColor(XSSFCellBorder.BorderSide.TOP);
    }

    public short getVerticalAlignment() {
        return (short)this.getVerticalAlignmentEnum().ordinal();
    }

    public VerticalAlignment getVerticalAlignmentEnum() {
        CTCellAlignment align = this.cellXf.getAlignment();
        if (align != null && align.isSetVertical()) {
            return VerticalAlignment.values()[align.getVertical().intValue() - 1];
        }
        return VerticalAlignment.BOTTOM;
    }

    public boolean getWrapText() {
        CTCellAlignment align = this.cellXf.getAlignment();
        return align != null && align.getWrapText();
    }

    public void setAlignment(short align) {
        this.getCellAlignment().setHorizontal(HorizontalAlignment.values()[align]);
    }

    public void setAlignment(HorizontalAlignment align) {
        this.setAlignment((short)align.ordinal());
    }

    public void setBorderBottom(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (border == 0) {
            ct.unsetBottom();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
        int idx = this.stylesSource.putBorder(new XSSFCellBorder(ct));
        this.cellXf.setBorderId(idx);
        this.cellXf.setApplyBorder(true);
    }

    public void setBorderBottom(BorderStyle border) {
        this.setBorderBottom((short)border.ordinal());
    }

    public void setBorderLeft(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (border == 0) {
            ct.unsetLeft();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
        int idx = this.stylesSource.putBorder(new XSSFCellBorder(ct));
        this.cellXf.setBorderId(idx);
        this.cellXf.setApplyBorder(true);
    }

    public void setBorderLeft(BorderStyle border) {
        this.setBorderLeft((short)border.ordinal());
    }

    public void setBorderRight(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
        if (border == 0) {
            ct.unsetRight();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
        int idx = this.stylesSource.putBorder(new XSSFCellBorder(ct));
        this.cellXf.setBorderId(idx);
        this.cellXf.setApplyBorder(true);
    }

    public void setBorderRight(BorderStyle border) {
        this.setBorderRight((short)border.ordinal());
    }

    public void setBorderTop(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
        if (border == 0) {
            ct.unsetTop();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
        int idx = this.stylesSource.putBorder(new XSSFCellBorder(ct));
        this.cellXf.setBorderId(idx);
        this.cellXf.setApplyBorder(true);
    }

    public void setBorderTop(BorderStyle border) {
        this.setBorderTop((short)border.ordinal());
    }

    public void setBottomBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setBottomBorderColor(clr);
    }

    public void setBottomBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetBottom()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this.stylesSource.putBorder(new XSSFCellBorder(ct));
        this.cellXf.setBorderId(idx);
        this.cellXf.setApplyBorder(true);
    }

    public void setDataFormat(short fmt) {
        this.cellXf.setApplyNumberFormat(true);
        this.cellXf.setNumFmtId(fmt);
    }

    public void setFillBackgroundColor(XSSFColor color) {
        CTFill ct = this.getCTFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetBgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setBgColor(color.getCTColor());
        }
        int idx = this.stylesSource.putFill(new XSSFCellFill(ct));
        this.cellXf.setFillId(idx);
        this.cellXf.setApplyFill(true);
    }

    public void setFillBackgroundColor(short bg) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(bg);
        this.setFillBackgroundColor(clr);
    }

    public void setFillForegroundColor(XSSFColor color) {
        CTFill ct = this.getCTFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetFgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setFgColor(color.getCTColor());
        }
        int idx = this.stylesSource.putFill(new XSSFCellFill(ct));
        this.cellXf.setFillId(idx);
        this.cellXf.setApplyFill(true);
    }

    public void setFillForegroundColor(short fg) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(fg);
        this.setFillForegroundColor(clr);
    }

    private CTFill getCTFill() {
        CTFill ct;
        if (this.cellXf.getApplyFill()) {
            int fillIndex = (int)this.cellXf.getFillId();
            XSSFCellFill cf = this.stylesSource.getFillAt(fillIndex);
            ct = (CTFill)cf.getCTFill().copy();
        } else {
            ct = CTFill.Factory.newInstance();
        }
        return ct;
    }

    private CTBorder getCTBorder() {
        CTBorder ct;
        if (this.cellXf.getApplyBorder()) {
            int idx = (int)this.cellXf.getBorderId();
            XSSFCellBorder cf = this.stylesSource.getBorderAt(idx);
            ct = (CTBorder)cf.getCTBorder().copy();
        } else {
            ct = CTBorder.Factory.newInstance();
        }
        return ct;
    }

    public void setFillPattern(short fp) {
        CTPatternFill ptrn;
        CTFill ct = this.getCTFill();
        CTPatternFill cTPatternFill = ptrn = ct.isSetPatternFill() ? ct.getPatternFill() : ct.addNewPatternFill();
        if (fp == 0 && ptrn.isSetPatternType()) {
            ptrn.unsetPatternType();
        } else {
            ptrn.setPatternType(STPatternType.Enum.forInt(fp + 1));
        }
        int idx = this.stylesSource.putFill(new XSSFCellFill(ct));
        this.cellXf.setFillId(idx);
        this.cellXf.setApplyFill(true);
    }

    public void setFillPattern(FillPatternType ptrn) {
        this.setFillPattern((short)ptrn.ordinal());
    }

    public void setFont(Font font) {
        if (font != null) {
            long index = font.getIndex();
            this.cellXf.setFontId(index);
            this.cellXf.setApplyFont(true);
        } else {
            this.cellXf.setApplyFont(false);
        }
    }

    public void setHidden(boolean hidden) {
        this.getCellProtection().setHidden(hidden);
    }

    public void setIndention(short indent) {
        this.getCellAlignment().setIndent(indent);
    }

    public void setLeftBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setLeftBorderColor(clr);
    }

    public void setLeftBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetLeft()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this.stylesSource.putBorder(new XSSFCellBorder(ct));
        this.cellXf.setBorderId(idx);
        this.cellXf.setApplyBorder(true);
    }

    public void setLocked(boolean locked) {
        this.getCellProtection().setLocked(locked);
    }

    public void setRightBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setRightBorderColor(clr);
    }

    public void setRightBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetRight()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this.stylesSource.putBorder(new XSSFCellBorder(ct));
        this.cellXf.setBorderId(idx);
        this.cellXf.setApplyBorder(true);
    }

    public void setRotation(short rotation) {
        this.getCellAlignment().setTextRotation(rotation);
    }

    public void setTopBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setTopBorderColor(clr);
    }

    public void setTopBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetTop()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this.stylesSource.putBorder(new XSSFCellBorder(ct));
        this.cellXf.setBorderId(idx);
        this.cellXf.setApplyBorder(true);
    }

    public void setVerticalAlignment(short align) {
        this.getCellAlignment().setVertical(VerticalAlignment.values()[align]);
    }

    public void setVerticalAlignment(VerticalAlignment align) {
        this.getCellAlignment().setVertical(align);
    }

    public void setWrapText(boolean wrapped) {
        this.getCellAlignment().setWrapText(wrapped);
    }

    public XSSFColor getBorderColor(XSSFCellBorder.BorderSide side) {
        switch (side) {
            case BOTTOM: {
                return this.getBottomBorderXSSFColor();
            }
            case RIGHT: {
                return this.getRightBorderXSSFColor();
            }
            case TOP: {
                return this.getTopBorderXSSFColor();
            }
            case LEFT: {
                return this.getLeftBorderXSSFColor();
            }
        }
        throw new IllegalArgumentException("Unknown border: " + (Object)((Object)side));
    }

    public void setBorderColor(XSSFCellBorder.BorderSide side, XSSFColor color) {
        switch (side) {
            case BOTTOM: {
                this.setBottomBorderColor(color);
                break;
            }
            case RIGHT: {
                this.setRightBorderColor(color);
                break;
            }
            case TOP: {
                this.setTopBorderColor(color);
                break;
            }
            case LEFT: {
                this.setLeftBorderColor(color);
            }
        }
    }

    private int getFontId() {
        if (this.cellXf.isSetFontId()) {
            return (int)this.cellXf.getFontId();
        }
        return (int)this.cellStyleXf.getFontId();
    }

    private CTCellProtection getCellProtection() {
        if (this.cellXf.getProtection() == null) {
            this.cellXf.addNewProtection();
        }
        return this.cellXf.getProtection();
    }

    protected XSSFCellAlignment getCellAlignment() {
        if (this.cellAlignment == null) {
            this.cellAlignment = new XSSFCellAlignment(this.getCTCellAlignment());
        }
        return this.cellAlignment;
    }

    private CTCellAlignment getCTCellAlignment() {
        if (this.cellXf.getAlignment() == null) {
            this.cellXf.setAlignment(CTCellAlignment.Factory.newInstance());
        }
        return this.cellXf.getAlignment();
    }

    public int hashCode() {
        return this.cellXf.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XSSFCellStyle)) {
            return false;
        }
        XSSFCellStyle cf = (XSSFCellStyle)o;
        return this.cellXf.toString().equals(cf.getCoreXf().toString());
    }

    public Object clone() {
        CTXf xf = (CTXf)this.cellXf.copy();
        int xfSize = this.stylesSource._getStyleXfsSize();
        int indexXf = this.stylesSource.putCellXf(xf);
        return new XSSFCellStyle(indexXf - 1, xfSize - 1, this.stylesSource);
    }
}

