/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.hwpf.model.BytePropertyNode;
import org.apache.poi.hwpf.model.ParagraphHeight;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.sprm.ParagraphSprmUncompressor;
import org.apache.poi.hwpf.sprm.SprmBuffer;
import org.apache.poi.hwpf.sprm.SprmOperation;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.util.LittleEndian;

public final class PAPX
extends BytePropertyNode {
    private ParagraphHeight _phe;
    private int _hugeGrpprlOffset = -1;

    public PAPX(int fcStart, int fcEnd, byte[] papx, ParagraphHeight phe, byte[] dataStream, boolean isUnicode) {
        super(fcStart, fcEnd, new SprmBuffer(papx), isUnicode);
        this._phe = phe;
        SprmBuffer buf = this.findHuge(new SprmBuffer(papx), dataStream);
        if (buf != null) {
            this._buf = buf;
        }
    }

    public PAPX(int fcStart, int fcEnd, SprmBuffer buf, byte[] dataStream, boolean isUnicode) {
        super(fcStart, fcEnd, buf, isUnicode);
        this._phe = new ParagraphHeight();
        buf = this.findHuge(buf, dataStream);
        if (buf != null) {
            this._buf = buf;
        }
    }

    private SprmBuffer findHuge(SprmBuffer buf, byte[] datastream) {
        short grpprlSize;
        int hugeGrpprlOffset;
        SprmOperation sprm;
        byte[] grpprl = buf.toByteArray();
        if (grpprl.length == 8 && datastream != null && ((sprm = new SprmOperation(grpprl, 2)).getOperation() == 69 || sprm.getOperation() == 70) && sprm.getSizeCode() == 3 && (hugeGrpprlOffset = sprm.getOperand()) + 1 < datastream.length && hugeGrpprlOffset + (grpprlSize = LittleEndian.getShort(datastream, hugeGrpprlOffset)) < datastream.length) {
            byte[] hugeGrpprl = new byte[grpprlSize + 2];
            hugeGrpprl[0] = grpprl[0];
            hugeGrpprl[1] = grpprl[1];
            System.arraycopy(datastream, hugeGrpprlOffset + 2, hugeGrpprl, 2, grpprlSize);
            this._hugeGrpprlOffset = hugeGrpprlOffset;
            return new SprmBuffer(hugeGrpprl);
        }
        return null;
    }

    public ParagraphHeight getParagraphHeight() {
        return this._phe;
    }

    public byte[] getGrpprl() {
        return ((SprmBuffer)this._buf).toByteArray();
    }

    public int getHugeGrpprlOffset() {
        return this._hugeGrpprlOffset;
    }

    public short getIstd() {
        byte[] buf = this.getGrpprl();
        if (buf.length == 0) {
            return 0;
        }
        return LittleEndian.getShort(buf);
    }

    public SprmBuffer getSprmBuf() {
        return (SprmBuffer)this._buf;
    }

    public ParagraphProperties getParagraphProperties(StyleSheet ss) {
        short istd = this.getIstd();
        ParagraphProperties baseStyle = ss.getParagraphStyle(istd);
        ParagraphProperties props = ParagraphSprmUncompressor.uncompressPAP(baseStyle, this.getGrpprl(), 2);
        return props;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return this._phe.equals(((PAPX)o)._phe);
        }
        return false;
    }
}

