/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.atp;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;
import org.apache.poi.hssf.record.formula.atp.YearFracCalculator;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.usermodel.DateUtil;

final class YearFrac
implements FreeRefFunction {
    public static final FreeRefFunction instance = new YearFrac();

    private YearFrac() {
    }

    public ValueEval evaluate(Eval[] args, EvaluationWorkbook workbook, int srcCellSheet, int srcCellRow, int srcCellCol) {
        double result;
        try {
            int basis = 0;
            switch (args.length) {
                case 3: {
                    basis = YearFrac.evaluateIntArg(args[2], srcCellRow, srcCellCol);
                }
                case 2: {
                    break;
                }
                default: {
                    return ErrorEval.VALUE_INVALID;
                }
            }
            double startDateVal = YearFrac.evaluateDateArg(args[0], srcCellRow, srcCellCol);
            double endDateVal = YearFrac.evaluateDateArg(args[1], srcCellRow, srcCellCol);
            result = YearFracCalculator.calculate(startDateVal, endDateVal, basis);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    private static double evaluateDateArg(Eval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, (short)srcCellCol);
        if (ve instanceof StringEval) {
            String strVal = ((StringEval)ve).getStringValue();
            Double dVal = OperandResolver.parseDouble(strVal);
            if (dVal != null) {
                return dVal;
            }
            Calendar date = YearFrac.parseDate(strVal);
            return DateUtil.getExcelDate(date, false);
        }
        return OperandResolver.coerceValueToDouble(ve);
    }

    private static Calendar parseDate(String strVal) throws EvaluationException {
        int f2;
        int f1;
        int f0;
        String[] parts = Pattern.compile("/").split(strVal);
        if (parts.length != 3) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        String part2 = parts[2];
        int spacePos = part2.indexOf(32);
        if (spacePos > 0) {
            part2 = part2.substring(0, spacePos);
        }
        try {
            f0 = Integer.parseInt(parts[0]);
            f1 = Integer.parseInt(parts[1]);
            f2 = Integer.parseInt(part2);
        }
        catch (NumberFormatException e) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        if (f0 < 0 || f1 < 0 || f2 < 0 || f0 > 12 && f1 > 12 && f2 > 12) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        if (f0 >= 1900 && f0 < 9999) {
            return YearFrac.makeDate(f0, f1, f2);
        }
        throw new RuntimeException("Unable to determine date format for text '" + strVal + "'");
    }

    private static Calendar makeDate(int year, int month, int day) throws EvaluationException {
        if (month < 1 || month > 12) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, 1, 0, 0, 0);
        cal.set(14, 0);
        if (day < 1 || day > ((Calendar)cal).getActualMaximum(5)) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        cal.set(5, day);
        return cal;
    }

    private static int evaluateIntArg(Eval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, (short)srcCellCol);
        return OperandResolver.coerceValueToInt(ve);
    }
}

