/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.AnimationInfoAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class AnimationInfo
extends RecordContainer {
    private byte[] _header = new byte[8];
    private AnimationInfoAtom animationAtom;

    protected AnimationInfo(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof AnimationInfoAtom) {
            this.animationAtom = (AnimationInfoAtom)this._children[0];
        } else {
            this.logger.log(7, "First child record wasn't a AnimationInfoAtom, was of type " + this._children[0].getRecordType());
        }
    }

    public AnimationInfo() {
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        this._children = new Record[1];
        this.animationAtom = new AnimationInfoAtom();
        this._children[0] = this.animationAtom;
    }

    public long getRecordType() {
        return RecordTypes.AnimationInfo.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, out);
    }

    public AnimationInfoAtom getAnimationInfoAtom() {
        return this.animationAtom;
    }
}

