/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.record.CurrentUserAtom;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.util.LittleEndian;

public final class UserEditAndPersistListing {
    private static byte[] fileContents;

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream baos;
        Record r;
        int i;
        if (args.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShow ss = new HSLFSlideShow(args[0]);
        fileContents = ss.getUnderlyingBytes();
        System.out.println("");
        Record[] records = ss.getRecords();
        int pos = 0;
        for (i = 0; i < records.length; ++i) {
            r = records[i];
            if (r.getRecordType() == 6001L) {
                System.out.println("Found PersistPtrFullBlock at " + pos + " (" + Integer.toHexString(pos) + ")");
            }
            if (r.getRecordType() == 6002L) {
                System.out.println("Found PersistPtrIncrementalBlock at " + pos + " (" + Integer.toHexString(pos) + ")");
                PersistPtrHolder pph = (PersistPtrHolder)r;
                int[] sheetIDs = pph.getKnownSlideIDs();
                Hashtable sheetOffsets = pph.getSlideLocationsLookup();
                for (int j = 0; j < sheetIDs.length; ++j) {
                    Integer id = new Integer(sheetIDs[j]);
                    Integer offset = (Integer)sheetOffsets.get(id);
                    System.out.println("  Knows about sheet " + id);
                    System.out.println("    That sheet lives at " + offset);
                    Record atPos = UserEditAndPersistListing.findRecordAtPos(offset);
                    System.out.println("    The record at that pos is of type " + atPos.getRecordType());
                    System.out.println("    The record at that pos has class " + atPos.getClass().getName());
                    if (atPos instanceof PositionDependentRecord) continue;
                    System.out.println("    ** The record class isn't position aware! **");
                }
            }
            baos = new ByteArrayOutputStream();
            r.writeOut(baos);
            pos += baos.size();
        }
        System.out.println("");
        pos = 0;
        for (i = 0; i < records.length; ++i) {
            r = records[i];
            if (r instanceof UserEditAtom) {
                UserEditAtom uea = (UserEditAtom)r;
                System.out.println("Found UserEditAtom at " + pos + " (" + Integer.toHexString(pos) + ")");
                System.out.println("  lastUserEditAtomOffset = " + uea.getLastUserEditAtomOffset());
                System.out.println("  persistPointersOffset  = " + uea.getPersistPointersOffset());
                System.out.println("  docPersistRef          = " + uea.getDocPersistRef());
                System.out.println("  maxPersistWritten      = " + uea.getMaxPersistWritten());
            }
            baos = new ByteArrayOutputStream();
            r.writeOut(baos);
            pos += baos.size();
        }
        System.out.println("");
        CurrentUserAtom cua = ss.getCurrentUserAtom();
        System.out.println("Checking Current User Atom");
        System.out.println("  Thinks the CurrentEditOffset is " + cua.getCurrentEditOffset());
        System.out.println("");
    }

    public static Record findRecordAtPos(int pos) {
        long type = LittleEndian.getUShort(fileContents, pos + 2);
        long rlen = LittleEndian.getUInt(fileContents, pos + 4);
        Record r = Record.createRecordForType(type, fileContents, pos, (int)rlen + 8);
        return r;
    }
}

